#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
#include <stack>
#include <climits>

using namespace std;

struct Mast {
    long long x, h;
    Mast(long long x = 0, long long h = 0) : x(x), h(h) {}
    bool operator<(const Mast& other) const {
        return x < other.x;
    }
};

vector<Mast> masts;
vector<pair<long long, long long>> prelomi;
vector<int> pge, nge;

void izracunajPrelome() {
    prelomi.resize(masts.size() - 1);
    for (int i = 0; i < (int)masts.size() - 1; ++i) {
        long long x_levo = masts[i].x;
        long long h_levo = masts[i].h;
        long long x_desno = masts[i+1].x;
        long long h_desno = masts[i+1].h;
        long long c = (h_levo + x_levo - h_desno + x_desno) / 2;
        long long y_c = h_levo - (c - x_levo);
        prelomi[i] = {c, y_c};
    }
}

void izracunajPGE() {
    int n = masts.size();
    pge.assign(n, -1);
    stack<int> stek;
    for (int i = 0; i < n; ++i) {
        while (!stek.empty() && masts[stek.top()].h < masts[i].h) {
            stek.pop();
        }
        if (!stek.empty()) {
            pge[i] = stek.top();
        }
        stek.push(i);
    }
}

void izracunajNGE() {
    int n = masts.size();
    nge.assign(n, -1);
    stack<int> stek;
    for (int i = n - 1; i >= 0; --i) {
        while (!stek.empty() && masts[stek.top()].h < masts[i].h) {
            stek.pop();
        }
        if (!stek.empty()) {
            nge[i] = stek.top();
        }
        stek.push(i);
    }
}

double izracunajRastojanje(long long x1, long long y1, long long x2, long long y2) {
    long long dx = x1 - x2;
    long long dy = y1 - y2;
    return sqrt(dx * dx + (long long)dy * dy);
}

void resi() {
    int n;
    cin >> n;
    vector<long long> x(n), h(n);
    for (int i = 0; i < n; ++i) cin >> x[i];
    for (int i = 0; i < n; ++i) cin >> h[i];
    
    masts.clear();
    for (int i = 0; i < n; ++i) {
        masts.emplace_back(x[i], h[i]);
    }
    sort(masts.begin(), masts.end());
    
    izracunajPrelome();
    izracunajPGE();
    izracunajNGE();
    
    for (int i = 0; i < n; ++i) {
        long long xi = masts[i].x;
        long long hi = masts[i].h;
        double min_rastojanje = 1e18;
        
        if (i < n - 1) {
            auto [c, yc] = prelomi[i];
            long long x_desno = masts[i+1].x;
            long long h_desno = masts[i+1].h;
            long long t_min = max(0LL, hi - yc);
            long long t_max = x_desno - c;
            if (t_min <= t_max) {
                long long A = xi - c;
                long long B = hi - yc;
                double optimalno_t = (A + B) / 2.0;
                optimalno_t = max(t_min, min(optimalno_t, (long long)t_max));
                long long x_tacka = c + (long long)optimalno_t;
                long long y_tacka = yc + (long long)optimalno_t;
                double dist = izracunajRastojanje(xi, hi, x_tacka, y_tacka);
                if (dist < min_rastojanje) {
                    min_rastojanje = dist;
                }
            }
        }
        
        if (i > 0) {
            auto [c, yc] = prelomi[i-1];
            long long x_levo = masts[i-1].x;
            long long h_levo = masts[i-1].h;
            long long max_x = x_levo + (h_levo - hi);
            max_x = min(max_x, c);
            if (max_x >= x_levo) {
                long long t_max_vrednost = max_x - x_levo;
                if (t_max_vrednost < 0) {
                } else {
                    long long A = xi - x_levo;
                    long long B = hi - h_levo;
                    double optimalno_t = (A - B) / 2.0;
                    optimalno_t = max(0.0, min(optimalno_t, (long long)t_max_vrednost));
                    long long x_tacka = x_levo + (long long)optimalno_t;
                    long long y_tacka = h_levo - (long long)optimalno_t;
                    double dist = izracunajRastojanje(xi, hi, x_tacka, y_tacka);
                    if (dist < min_rastojanje) {
                        min_rastojanje = dist;
                    }
                }
            }
        }
        
        if (pge[i] != -1) {
            int j = pge[i];
            if (masts[j].h >= hi) {
                double dist = izracunajRastojanje(xi, hi, masts[j].x, masts[j].h);
                if (dist < min_rastojanje) {
                    min_rastojanje = dist;
                }
            }
        }
        
        if (nge[i] != -1) {
            int j = nge[i];
            if (masts[j].h >= hi) {
                double dist = izracunajRastojanje(xi, hi, masts[j].x, masts[j].h);
                if (dist < min_rastojanje) {
                    min_rastojanje = dist;
                }
            }
        }
        
        if (min_rastojanje >= 1e17) {
            cout << -1 << endl;
        } else {
            cout << (long long)round(min_rastojanje) << endl;
        }
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    
    resi();
    
    return 0;
}